@extends('layouts.app')

@section('title', 'All Appointments')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">All Appointments</h1>
        <a href="{{ route('admin.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Doctor</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date/Time</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Type</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($appointments as $appointment)
                <tr>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <div>
                            <div class="font-medium text-sm sm:text-base">{{ $appointment->patient->full_name }}</div>
                            <div class="text-xs sm:text-sm text-gray-500">{{ $appointment->patient->patient_id }}</div>
                        </div>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                        <span class="text-sm">{{ $appointment->doctor ? $appointment->doctor->full_name : 'Not Assigned' }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                        <span class="text-sm">{{ $appointment->branch->name }}</span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        @if($appointment->appointment_date)
                            <span class="text-xs sm:text-sm">{{ $appointment->appointment_date->format('M d, Y H:i') }}</span>
                        @else
                            <span class="text-gray-400 text-xs sm:text-sm">Immediate</span>
                        @endif
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="bg-purple-100 text-purple-800 px-2 py-1 rounded text-xs">
                            {{ ucfirst($appointment->appointment_type) }}
                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs rounded-full 
                            @if($appointment->status === 'completed') bg-green-100 text-green-800
                            @elseif($appointment->status === 'pending') bg-yellow-100 text-yellow-800
                            @elseif($appointment->status === 'in_progress') bg-blue-100 text-blue-800
                            @elseif($appointment->status === 'cancelled') bg-red-100 text-red-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst($appointment->status) }}
                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                        <div class="flex flex-col gap-1">
                            @if($appointment->prescription)
                                <a href="{{ route('prescriptions.show', $appointment->prescription->id) }}" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-prescription"></i> <span class="hidden sm:inline">View Prescription</span><span class="sm:hidden">Prescription</span>
                                </a>
                            @endif
                            @if($appointment->google_meet_link)
                                <a href="{{ $appointment->google_meet_link }}" class="text-green-600 hover:text-green-900" target="_blank">
                                    <i class="fas fa-video"></i> <span class="hidden sm:inline">Google Meet</span><span class="sm:hidden">Meet</span>
                                </a>
                            @elseif($appointment->video_call_room_id)
                                <a href="{{ $appointment->appointment_type === 'immediate' ? route('pharmacist.video-call', $appointment->id) : '#' }}" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-video"></i> <span class="hidden sm:inline">Video Call</span><span class="sm:hidden">Call</span>
                                </a>
                            @endif
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                        No appointments found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
        </div>
    </div>

    @if($appointments->count() > 0)
    <div class="mt-4 text-sm text-gray-600">
        Showing {{ $appointments->count() }} appointment(s)
    </div>
    @endif
</div>
@endsection

